/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (10/05/07)
 */   
package com.ejie.p06b.p06bMediadoresSegurosEJB;



import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

import com.ejie.p06b.datatype.logic.P06BCorredor;
import com.ejie.p06b.datatype.logic.P06BPRDListasAux;
import com.ejie.p06b.datatype.logic.P06BNumeracionesComp;
import com.ejie.p06b.datatype.model.P06B20T00Datatype;
import com.ejie.p06b.datatype.model.P06B31T00Datatype;
import com.ejie.p06b.datatype.model.P06B60T00Datatype;
import com.ejie.p06b.datatype.model.P06B64T00Datatype;
import com.ejie.p06b.datatype.model.P06B81T00Datatype;
import com.ejie.p06b.exception.P06BException;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.manager.P06BCorredoresManager;
import com.ejie.p06b.manager.P06BPRDsManager;
import com.ejie.p06b.manager.P06BTestManager;

/**
 * XDoclet-based session bean.  The class must be declared
 * public according to the EJB specification.
 *
 * To generate the EJB related files to this EJB:
 *		- Add Standard EJB module to XDoclet project properties
 *		- Customize XDoclet configuration for your appserver
 *		- Run XDoclet
 *
 * Below are the xdoclet-related tags needed for this EJB.
 * 
 * @ejb.bean name="P06BMediadoresSegurosEJB"
 *           display-name="Name for P06BMediadoresSegurosEJB"
 *           description="Description for P06BMediadoresSegurosEJB"
 *           jndi-name="p06b.p06bMediadoresSegurosEJB"
 *           type="Stateless"
 *           view-type="remote"
 * @weblogic.enable-call-by-reference="True"
 */
public class P06BMediadoresSegurosEJBBean implements SessionBean {

	/** The session context */
	private SessionContext context;

	/**
	 * 
	 */
	public P06BMediadoresSegurosEJBBean() {
		super();
	}

	/**
	 * Set the associated session context. The container calls this method 
	 * after the instance creation.
	 * 
	 * The enterprise bean instance should store the reference to the context 
	 * object in an instance variable.
	 * 
	 * This method is called with no transaction context. 
	 * 
	 * @throws EJBException Thrown if method fails due to system-level error.
	 */
	public void setSessionContext(SessionContext newContext)
		throws EJBException {
		context = newContext;
	}

	/* (non-Javadoc)
	 * @see javax.ejb.SessionBean#ejbRemove()
	 */
	public void ejbRemove() throws EJBException, RemoteException {
	}

	/* (non-Javadoc)
	 * @see javax.ejb.SessionBean#ejbActivate()
	 */
	public void ejbActivate() throws EJBException, RemoteException {
	}

	/* (non-Javadoc)
	 * @see javax.ejb.SessionBean#ejbPassivate()
	 */
	public void ejbPassivate() throws EJBException, RemoteException {
	}

	

   /**
    * Prueba de Test del funcionamiento del EJB de la aplicacin
    * 
    * @param obj.
    *            Objeto a insertar y borrar
    * @param conError.
    *            Indica si hay error. Si hay error, se fuerza insercin
    * 			 antes de hacer delete. Asi probamos la transaccionalidad del EJB.
    * @throws P06BException
    * 
    * @ejb.interface-method
    * @ejb.transaction type="RequiresNew"
    */
	public void testEJB(P06BNumeracionesComp obj, boolean conError)
							throws P06BException {
		P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - testEJB INICIO");
		try{
			P06BTestManager.getInstance().insertAndDelete(obj,conError);
			P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - testEJB FIN");
		}catch(P06BException e){
			context.setRollbackOnly();
			P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - testEJB Error - Realiza EJB-Rollback");
			throw e;
		}
	}
	
	/**
    * Inserta un Corredor y su informacin asociada en nuestro sistema
    * 
    * @param obj.
    *            Objeto a insertar 	
    * @return String 
    * 			 El expediente creado en el sistema
    * @throws P06BException
    * 
    * @ejb.interface-method
    * @ejb.transaction type="RequiresNew"
    */
	public String insertCorredor(P06BCorredor obj)
							throws P06BException {
		P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - insertCorredor INICIO");
		String result = "";
		try{
			//Inserto los datos del corredor
			result = P06BCorredoresManager.getInstance().insertCorredor(obj.getDatosCorredor());
			//Inserto la lista de socios directos
			P06BCorredoresManager.getInstance().insertSocios(obj.getListas().getListaSocios(),result);
			//Inserto la lista de socios indirectos
			P06BCorredoresManager.getInstance().insertSociosIndirec(obj.getListas().getListaSociosIndirec(),result);
			//Inserto la lista de auxiliares externos
			P06BCorredoresManager.getInstance().insertAuxExternos(obj.getListas().getListaAuxExternos(),result);
			//Inserto la lista de administradores
			P06BCorredoresManager.getInstance().insertAdministradores(obj.getListas().getListaAdministradores(),result);
			//Inserto la lista de organos
			P06BCorredoresManager.getInstance().insertOrganosDir(obj.getListas().getListaOrganos(),result);
			//Inserto la lista de direccin tcnica
			P06BCorredoresManager.getInstance().insertDirecTec(obj.getListas().getListaDirecTec(),result);
			//Inserto la lista de otras personas direccin
			P06BCorredoresManager.getInstance().insertOtrosDirec(obj.getListas().getListaOtrosDirec(),result);
			//Inserto la lista de sucursales
			P06BCorredoresManager.getInstance().insertSucursales(obj.getListas().getListaSucursales(),result);
			//Inserto la lista de defensores de cliente
			P06BCorredoresManager.getInstance().insertDefCliente(obj.getListas().getListaDefCliente(),result);
			//Inserto la lista de departamentos de atencin al cliente
			P06BCorredoresManager.getInstance().insertDepAtCliente(obj.getListas().getListaDepAtCliente(),result);
			//Inserto la lista de departamentos de atencin al cliente
			P06BCorredoresManager.getInstance().insertEVs(obj.getListas().getListaEVs(),result);
			
			P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - insertCorredor FIN Devuelve:"+result);
			return result;
		}catch(P06BException e){
			context.setRollbackOnly();
			P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - insertCorredor Error - Realiza EJB-Rollback");
			throw e;
		}
	}
	
	/**
    * Modifica un Corredor y su informacin asociada en nuestro sistema
    * 
    * @param obj.
    *            Objeto a actualizar 	
    * @return String 
    * 			 El expediente modificado en el sistema
    * @throws P06BException
    * 
    * @ejb.interface-method
    * @ejb.transaction type="RequiresNew"
    */
	public String updateCorredor(P06BCorredor obj) throws P06BException {
		P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - updateCorredor INICIO");
		String result = "";
		try{
			P06B20T00Datatype p06B20T00Datatype = obj.getDatosCorredor();
			
			//Incorporar al corredor los datos de Prxima atencin de peticin
        	if (p06B20T00Datatype.getCorrelAtencionPeticionEnRevision() != -1){
		        P06BCorredoresManager.getInstance().updateEstadoAtencionPeticion(p06B20T00Datatype.getCorrelAtencionPeticionEnRevision(),p06B20T00Datatype.getEstadoAceptarPropuestas());
        	}else{
        		String estadoAntiguo = P06BCorredoresManager.getInstance().selectEstadoCorredor(p06B20T00Datatype.getExpedi().toUpperCase());
        		byte estadoAtencionPeticion = -1;
        		if (estadoAntiguo.equals(P06BConstantes.P06B_CORREDORES_ESTADO_PDTE_ALTA)){
        			if (p06B20T00Datatype.getEstado().equals(P06BConstantes.P06B_CORREDORES_ESTADO_ALTA_RECHAZADA)){
        				estadoAtencionPeticion = P06BConstantes.P06B_AP_ESTADO_RECHAZADA;
        			}else if (p06B20T00Datatype.getEstado().equals(P06BConstantes.P06B_CORREDORES_ESTADO_ALTA)){
        				P06BCorredoresManager.getInstance().insertAdjuntosExpFromCorrelAtencPetic(p06B20T00Datatype.getExpedi().toUpperCase(), p06B20T00Datatype.getUltAtencPeticIncorporada());
        				estadoAtencionPeticion = P06BConstantes.P06B_AP_ESTADO_APROBADA;
        			}	
        		}else if (estadoAntiguo.equals(P06BConstantes.P06B_CORREDORES_ESTADO_PDTE_BAJA)){
        			if (p06B20T00Datatype.getEstado().equals(P06BConstantes.P06B_CORREDORES_ESTADO_ALTA)){
        				estadoAtencionPeticion = P06BConstantes.P06B_AP_ESTADO_RECHAZADA;
        			}else if (p06B20T00Datatype.getEstado().equals(P06BConstantes.P06B_CORREDORES_ESTADO_BAJA)){
        				P06BCorredoresManager.getInstance().insertAdjuntosExpFromCorrelAtencPetic(p06B20T00Datatype.getExpedi().toUpperCase(), p06B20T00Datatype.getUltAtencPeticIncorporada());
        				estadoAtencionPeticion = P06BConstantes.P06B_AP_ESTADO_APROBADA;
        			}	
        		}
        		if (estadoAtencionPeticion!=-1){
    		        P06BCorredoresManager.getInstance().updateEstadoAtencionPeticion(p06B20T00Datatype.getUltAtencPeticIncorporada(),estadoAtencionPeticion);
        		}
        	}
        	
        	P06B60T00Datatype datosCapacidadFinanciera = p06B20T00Datatype.getDatosCapacidadFinanciera();
			result = P06BCorredoresManager.getInstance().updateCorredor(p06B20T00Datatype);

			if (p06B20T00Datatype.getDatosAtencionPeticionEnRevision()==null ||
				p06B20T00Datatype.getDatosAtencionPeticionEnRevision().isbActualizarCapacidadFinanciera()){
				if (p06B20T00Datatype.getClase().equals(P06BConstantes.P06B_AGENTEVINCULADO_FISICA) ||
					p06B20T00Datatype.getClase().equals(P06BConstantes.P06B_AGENTEVINCULADO_JURIDICA) ||
					p06B20T00Datatype.getClase().equals(P06BConstantes.P06B_CORREDORES_TIPOPER_FISICA) ||
					p06B20T00Datatype.getClase().equals(P06BConstantes.P06B_CORREDORES_TIPOPER_JURIDICA)){
					P06BCorredoresManager.getInstance().updateCapacidadFinanciera(datosCapacidadFinanciera);
				}
			}
			if (p06B20T00Datatype.getDatosAtencionPeticionEnRevision()==null ||
				p06B20T00Datatype.getDatosAtencionPeticionEnRevision().isbActualizarCapitalSocial()){
				P06BCorredoresManager.getInstance().deleteAndInsertListaSocios(obj.getListas().getListaSocios(),p06B20T00Datatype,result);				
			}
			if (p06B20T00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_ENSISTEMA){
				P06BCorredoresManager.getInstance().deleteAndInsertListaSociosIndirec(obj.getListas().getListaSociosIndirec(),result);
				P06BCorredoresManager.getInstance().deleteAndInsertListaAuxExternos(obj.getListas().getListaAuxExternos(),result);				
			}
			if (p06B20T00Datatype.getDatosAtencionPeticionEnRevision()==null ||
					p06B20T00Datatype.getDatosAtencionPeticionEnRevision().isbActualizarAdministradores()){
				P06BCorredoresManager.getInstance().deleteAndInsertListaAdministradores(obj.getListas().getListaAdministradores(),p06B20T00Datatype,result);				
			}
			if (p06B20T00Datatype.getDatosAtencionPeticionEnRevision()==null ||
					p06B20T00Datatype.getDatosAtencionPeticionEnRevision().isbActualizarOrganoDireccion()){
				P06BCorredoresManager.getInstance().deleteAndInsertListaOrganosDir(obj.getListas().getListaOrganos(),p06B20T00Datatype,result);				
			}
			if (false){
				P06BCorredoresManager.getInstance().deleteAndInsertListaDirecTec(obj.getListas().getListaDirecTec(),p06B20T00Datatype,result);
				P06BCorredoresManager.getInstance().deleteAndInsertListaOtrosDirec(obj.getListas().getListaOtrosDirec(),p06B20T00Datatype,result);				
			}
			if (p06B20T00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_ENSISTEMA){
				P06BCorredoresManager.getInstance().deleteAndInsertListaSucursales(obj.getListas().getListaSucursales(),result);
			}
			if (p06B20T00Datatype.getDatosAtencionPeticionEnRevision()==null ||
					p06B20T00Datatype.getDatosAtencionPeticionEnRevision().isbActualizarAtencionDefensaCliente()){
				if (p06B20T00Datatype.getClase().equals(P06BConstantes.P06B_REASEGUROS_FISICA) ||
					p06B20T00Datatype.getClase().equals(P06BConstantes.P06B_REASEGUROS_JURIDICA) ||
					p06B20T00Datatype.getClase().equals(P06BConstantes.P06B_CORREDORES_TIPOPER_FISICA) ||
					p06B20T00Datatype.getClase().equals(P06BConstantes.P06B_CORREDORES_TIPOPER_JURIDICA)){
					P06BCorredoresManager.getInstance().deleteAndInsertListaDefCliente(obj.getListas().getListaDefCliente(),p06B20T00Datatype,result);
					P06BCorredoresManager.getInstance().deleteAndInsertListaDepAtCliente(obj.getListas().getListaDepAtCliente(),p06B20T00Datatype,result);
					}
			}
			if (p06B20T00Datatype.getDatosAtencionPeticionEnRevision()==null ||
					p06B20T00Datatype.getDatosAtencionPeticionEnRevision().isbActualizarEntidadesVinculadas()){
				P06BCorredoresManager.getInstance().deleteAndInsertListaEVs(obj.getListas().getListaEVs(),p06B20T00Datatype,result);
			}
			if (p06B20T00Datatype.getDatosAtencionPeticionEnRevision()!=null &&
					p06B20T00Datatype.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA){				
				P06BCorredoresManager.getInstance().insertAdjuntosExpFromCorrelAtencPetic(p06B20T00Datatype.getExpedi().toUpperCase(), p06B20T00Datatype.getCorrelAtencionPeticionEnRevision());
			}
			
			P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - updateCorredor FIN Devuelve:"+result);
			return result;
		}catch(P06BException e){
			context.setRollbackOnly();
			P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - updateCorredor Error - Realiza EJB-Rollback");
			throw e;
		}
	}
	
	/**
    * Modifica un Periodos y su informacin asociada en nuestro sistema
    * 
    * @param obj.
    *            Objeto a actualizar 	
    * @return String 
    * 			 El expediente modificado en el sistema
    * @throws P06BException
    * 
    * @ejb.interface-method
    * @ejb.transaction type="RequiresNew"
    */
	public void updatePeriodos(P06BPRDListasAux obj)
							throws P06BException {
		P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - updatePeriodos INICIO");
		try{
			P06BPRDsManager.getInstance().deleteAndInsertListaPRDs(obj.getListaPeriodos());
			
			P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - updatePeriodos FIN");
		}catch(P06BException e){
			context.setRollbackOnly();
			P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - updatePeriodos Error - Realiza EJB-Rollback");
			throw e;
		}
	}
		
	/**
    * Inserta un Documento Adjunto para un expediente determinado, en nuestro sistema
    * 
    * @param obj.
    *            Objeto a insertar 	
    * @return P06B31T00Datatype
    * 			El documento adjuntado 
    * @throws P06BException
    * 
    * @ejb.interface-method
    * @ejb.transaction type="RequiresNew"
    */
	public P06B31T00Datatype insertDocAdjunto(P06B31T00Datatype obj)
							throws P06BException {
		P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - insertDocAdjunto INICIO");
		P06B31T00Datatype docAdjunto = new P06B31T00Datatype();
		try{
			//Inserto el documento adjunto
			docAdjunto = P06BCorredoresManager.getInstance().insertDocAdjunto(obj);
			
			P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - insertDocAdjunto FIN");
		}catch(P06BException e){
			context.setRollbackOnly();
			P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - insertDocAdjunto Error - Realiza EJB-Rollback");
			throw e;
		}
		return docAdjunto;
	}

	
	/**
    * Borra un Documento Adjunto para un expediente determinado, en nuestro sistema
    * 
    * @param obj.
    *            Objeto a borrar 	
    * @return void 
    * @throws P06BException
    * 
    * @ejb.interface-method
    * @ejb.transaction type="RequiresNew"
    */
	public void borrarDocAdjunto(P06B31T00Datatype obj)
							throws P06BException {
		P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - borrarDocAdjunto INICIO");
		try{
			P06BCorredoresManager.getInstance().borrarDocAdjunto(obj);
			
			P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - borrarDocAdjunto FIN");
		}catch(P06BException e){
			context.setRollbackOnly();
			P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - borrarDocAdjunto Error - Realiza EJB-Rollback");
			throw e;
		}
	}
	
	
	/**
    * Borra un Documento Tramitagune para un expediente determinado, en nuestro sistema
    * 
    * @param obj.
    *            Objeto a borrar 	
    * @return void 
    * @throws P06BException
    * 
    * @ejb.interface-method
    * @ejb.transaction type="RequiresNew"
    */
	public void borrarDocTramitagune(P06B81T00Datatype obj)
							throws P06BException {
		P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - borrarDocTramitagune INICIO");
		try{
			P06BCorredoresManager.getInstance().borrarDocTramitagune(obj);
			
			P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - borrarDocTramitagune FIN");
		}catch(P06BException e){
			context.setRollbackOnly();
			P06BLog.send(0,this,"P06BMediadoresSegurosEJBBean - borrarDocTramitagune Error - Realiza EJB-Rollback");
			throw e;
		}
	}
		
		
		
			
		
}